/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 *====================
 * Includes
 *====================
 */
#include <stdio.h>
#include "dm388_EVM.h"
#include "dm388_types.h"
#include "dm388_hdmi.h"


Int16 LCD_VPSS_Config(void) {
	
	
	INT16 retVal = SUCCESS;
	
	
// Configure the VOUT0 VPSS registers
	platform_write("Configuring the VOUT0 VPSS registers\n");
	WR_MEM_32(DVO2_CFG0, 
					((3 << 0) |		// 720p format, 
					 (0 << 3) |		// Progressive scan
					 (1 << 4) |		// Bypass 2x up-sampling
					 (1 << 5) |		// Bypass color space converter
					 (0 << 6) |		// RGB Color space
					 (1 << 13) |	// Bypass Gamma correction
					 (3 << 16)));	// 3 channel, 10 bit video, dedicated HS/VS/FID/ACTVID, format: RGB or YCbCr 444
	
	WR_MEM_32(DVO2_CFG10,
					((0x47D << 0) |	// Pixels per line: 1150
					(0x2DD << 12) |	// Lines per frame: 733
					(0x0 << 24)));	// Clamp: 0
	
	WR_MEM_32(DVO2_CFG11,
					((0x15 << 0) |	// v_bla1: 21
					(0x248 << 12) |	// v_bla2: 584
					(0x2C << 24)));	// eq_width: 44
	
	WR_MEM_32(DVO2_CFG12,
					((0x7D << 0) |	// h_blank: 126	(HSYNC_LOW(30) + HORZ_BACK_PORCH(60) + HORZ_FRONT_PORCH(36))
					(0x400 << 12) |	// act_pix: 1024
					(0x1E << 24)));	// hs_wth: 30
	
	WR_MEM_32(DVO2_CFG13,
					((0x232 << 0) |	// end_f1: 562
					(0x0 << 12)));	// osd_hbi_st: 0
	
	WR_MEM_32(DVO2_CFG15,
					((0x5A << 0) |	// dvo_avst_h: 90	(HSYNC_LOW(30) + HORZ_BACK_PORCH(60))
					(0x400 << 12) |	// dvo_avd_hw: 1024
					(0x1E << 24)));	// dvo_hs_wd: 30
	
	WR_MEM_32(DVO2_CFG16,
					((0x0 << 0) |	// dvo_hs_st: 0
					(0x15 << 12)));	// dvo_avst_v1: 21
	
	WR_MEM_32(DVO2_CFG17,
					((0x247 << 0) |	// dvo_avst_v2: 583
					(0x21C << 12)));// dvo_avd_vw1: 540
	
	WR_MEM_32(DVO2_CFG18,
					((0x21C << 0) |	// dvo_avd_vw2: 540
					(0x2 << 12) |	// dvo_vs_st1: 2
					(0x5 << 24)));	// dvo_vs_wd1: 5
	
	WR_MEM_32(DVO2_CFG19,
					((0x234 << 0) |	// dvo_vs_st2: 564
					(0x1 << 12) |	// dvo_fid_st1: 1
					(0x5 << 24)));	// dvo_vs_wd2: 5
	
	WR_MEM_32(DVO2_CFG20,
					((0x234 << 0) |	// dvo_fid_st2: 564
					(0x234 << 12)));// osd_fid_st2: 564
	
	WR_MEM_32(DVO2_CFG21,
					((0x52 << 0) |	// osd_avst_h: 82	(dvo_avst_h - 8)
					(0x400 << 12) |	// osd_avd_hw: 1024
					(0x1E << 24)));	// osd_hs_wd: 30
	
	WR_MEM_32(DVO2_CFG22,
					((0x1 << 0) |	// osd_hs_st: 1
					(0x15 << 12)));	// osd_avst_v1: 21
	
	WR_MEM_32(DVO2_CFG23,
					((0x247 << 0) |	// osd_avst_v2: 583
					(0x21C << 12)));// osd_avd_vw1: 540
	
	WR_MEM_32(DVO2_CFG24,
					((0x21C << 0) |	// osd_avd_vw2: 540
					(0x1 << 12) |	// osd_vs_st1: 1
					(0x5 << 24)));	// osd_vs_wd1: 5
	
	WR_MEM_32(DVO2_CFG25,
					((0x234 << 0) |	// osd_vs_st2: 564
					(0x1 << 12) |	// osd_fid_st1: 1
					(0x5 << 24)));	// osd_vs_wd2: 5
	
	WR_MEM_32(DVO2_CFG0, (RD_MEM_32(DVO2_CFG0) | (1 << 15)));		// Enable Self Test mode, Generate color bar pattern
	WR_MEM_32(DVO2_CFG0, (RD_MEM_32(DVO2_CFG0) | (1 << 30)));		// Start normal operation for encoder
	
   return retVal;
}

